import java.sql.*;

public class Esercizio_1_1 {
	public static void main(String[] arg){
		Connection con = null;
		try { // Caricamento del driver (due driver diversi, scegliere; notare i msg diversi)
			Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
//			Class.forName("com.ibm.db2.jcc.DB2Driver");
		}
		catch (ClassNotFoundException exClass) {
			System.err.println("Fallito il caricamento del driver");
			return;
		}
		try { // Apertura della connessione (scegliere il nome, coerentemente con il driver)
			String url = "jdbc:odbc:EsercSQL";
//			String url = "jdbc:db2:esempio";
			con = DriverManager.getConnection(url);
		}
		catch (SQLException exSQL) {
			System.err.println("Fallita connessione al database.");
			System.err.println("SQL Error Code: " + exSQL.getErrorCode()
					+ ", SQL State" + exSQL.getSQLState());
			System.err.println("SQL Message: " + exSQL.getMessage());
			return;
		}

		try { // Esecuzione dell'interrogazione SQL
			Statement unaDDL = con.createStatement();
//			unaDDL.executeUpdate( "DROP TABLE Fornitori "  );
//			System.out.println("La vecchia tabella Fornitori e' stata eliminata.");
			unaDDL.executeUpdate( "CREATE TABLE Fornitori ("  +
					"CodiceFornitore   VARCHAR (8)  NOT NULL, "  +
					"Nome              VARCHAR (20) NOT NULL, "  +
					"Indirizzo         VARCHAR (30)         , "  +
					"Citta             VARCHAR (20)         , "  +
					"PRIMARY KEY( CodiceFornitore )"             +
			")" );
			System.out.println("La tabella Fornitori e' stata creata.");
		}
		catch (SQLException exSQL){
			System.err.println("Errore nella creazione della tabella");
			System.err.println("SQL Error Code: " + exSQL.getErrorCode()
					+ ", SQL State" + exSQL.getSQLState());
			System.err.println("SQL Message: " + exSQL.getMessage());
		}
		finally{
//			Chiudere SEMPRE le connessioni
			try {
				con.close();
				System.out.println("Chiusa connessione al database.");
			}
			catch (SQLException exSQL) {
				System.err.println("Errore nella chiusura connessione al database.");
				System.err.println("SQL Error Code: " + exSQL.getErrorCode()
						+ ", SQL State" + exSQL.getSQLState());
				System.err.println("SQL Message: " + exSQL.getMessage());
			}
		}
	}
}